--
--
------------------------------------------------------------------------------------------------------- 
-- Miguel Fichier Revision M33.d
------------------------------------------------------------------------------------------------------- 
-- Miguel21 modification M33.d VOR + NDB Custom Briefing (d: Divert)

--[[ db_airbases Entry Example ----------------------------------------------------------------------------
	--example for an air base
	['Kerman Airbase'] = {
		x =	454116.78125,
		y = 71096.058594,
		elevation = 1751,
		airdromeId = 18,
		ATC_frequency = "250.300",
		--startup = 300,							-- (secondes) Timing for take-off, generally used for small runways to give time for all aircraft to gather together
		side = "red",								-- side : Required information for the divert
		divert = true,								-- divert : Required information for the divert)
		--VOR = "112.00",							-- optional information
		--NDB = "",									-- optional information
		--TACAN = "97X",							-- TACAN : optional information
		--ILS = "RNW 30R/111.95 RNW 12L/108.55",	-- ILS : optional information
		LimitedParkNb = 3,							-- number of parking spaces available
	},
	--example for an airplane carrier
	['CVN-71 Theodore Roosevelt'] = {                            
		unitname = "CVN-71 Theodore Roosevelt",
		startup = 300,								-- (secondes) Timing for take-off, generally used for small runways to give time for all aircraft to gather together
		ATC_frequency = "255.500",					-- Optional information, if absent, the base_mission frequency will be used.
	},	
	--example for a FARP
	['As Salamah FARP'] = {
		x =	-74348.375716192,
		y = -67705.331836707,
		elevation = 0,
		airdromeId = 837,							--be careful this Id depends on units placements and is helipadID in fact
		helipadId = 837,
		ATC_frequency = "128.600",
		side = "blue",								-- side : Required information for the divert
		divert = false,								-- divert : Required information for the divert)
	},	
	--example for a Virtual Base
	['Reserves'] = {								--dummy airbase to place virtual reserves
		inactive = true,
		x =	9999999999,								--position far away will make all range checks negative
		y = 9999999999,
		elevation = 0,
		airdromeId = nil,							--no id makes sure that no static aircraft are to be placed at this air base
		ATC_frequency = "0",
	},

]]-----------------------------------------------------------------------------------------------------

db_airbases = {
	['Abu Musa Island'] = {		
		ATC_frequency = {250.4, 122.9, 38.85, 3.975},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 8,
		LimitedSmallParkNb = '',
		NDB = '285',
		airdromeId = 1,
		code = {
			ICAO = 'OIBA',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 5,
		parkAlertSAR = {
			{
				["y"] = -121745.41132259,
				["x"] = -31401.237861967,
			},
			{
				["y"] = -121545.92097445,
				["x"] = -31360.092977663,
			},			
			{
				["y"] = -121411.26498946,
				["x"] = -31350.118460255,
			},
			{
				["y"] = -121236.71093483,
				["x"] = -31343.884386876,
			},
			{
				["y"] = -120324.04259209,
				["x"] = -31231.671066047,
			},
			{
				["y"] = -120203.10156853,
				["x"] = -31220.449733964,
			},
			{
				["y"] = -119911.34693437,
				["x"] = -31231.671066047,
			},
			{
				["y"] = -119785.41865211,
				["x"] = -31254.113730213,
			},
		},
		runways = {
			{
				hdg = 82,
				length = 2300,
				name = '08-26',
				x =	-31593.10546875,
				y = -122493.0546875,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,
		x =	-31593.10546875,
		y = -122493.0546875,
	},
	['Bandar Abbas Intl'] = {
		ATC_frequency = {251, 118.1, 39.4, 4.25},
		ILS = 'RNW 21L : 109.90 || ',							-- ILS : optionnel
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 50,
		LimitedSmallParkNb = '',
		VOR = '117.20',
		NDB = '250',
		TACAN = '78X',							-- TACAN : optionnel		
		airdromeId = 2,
		code = {
			ICAO = 'OIKB',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 5,		
		parkAlertSAR = {
			{
				["y"] = 14918.519691508,
                ["x"] = 117227.18103902,
			},
			{
				["y"] = 14853.823018626,
                ["x"] = 117158.90666994,
			},			
			{
				["y"] = 14549.452147166,
                ["x"] = 116604.67708543,
			},
			{
				["y"] = 14617.639818645,
                ["x"] = 116713.33979185,
			},
			{
				["y"] = 14669.70249274,
                ["x"] = 116822.00741039,
			},
			{
				["y"] = 14710.00523827,
                ["x"] = 116911.43318284,
			},
			{
				["y"] = 14761.82338961,
                ["x"] = 116965.36131942,
			},
			{
				["y"] = 14821.428504059,
                ["x"] = 117034.34018354,
			},
		},
		runways = {
			{
				hdg = 025,
				length = 3300,
				name = '03L-21R',
				x =	115843.79722451,   
				y = 14010.071651486,
			},
			{
				hdg = 025,
				length = 3500,
				name = '03R-21L',     ---  Principale
				x =	114214.0546875,    ---à verifier
				y = 13397.94140625,
			},
		},
		side = "blue",							-- side : info obligatoire
		startup = 300,
		x =	114214.0546875,
		y = 13397.94140625,
	},
	['Bandar Lengeh'] = {
		ATC_frequency = {251.05, 121.7, 39.45, 4.275},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 5,
		LimitedSmallParkNb = '',
		VOR = "114.80",
		NDB = "408",
		airdromeId = 3,
		code = {
			ICAO = 'OIBL',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 23,
		parkAlertSAR = {
			{
				["y"] = -141740.71448336,
                ["x"] = 41328.082484485,
			},
			{
				["y"] = -141266.5471849,
                ["x"] = 41394.168519115,
			},			
			{
				["y"] = -140551.16586003,
                ["x"] = 41506.514777985,
			},
			{
				["y"] = -140404.12443298,
                ["x"] = 41531.297040971,
			},
			{
				["y"] = -140141.88007677,
                ["x"] = 41567.428123207,
			},
			{
				["y"] = -139975.93416291,
                ["x"] = 41596.666212792,
			},
			{
				["y"] = -139787.80957767,
                ["x"] = 41637.901401729,
			},
			{
				["y"] = -139661.25628648,
                ["x"] = 41645.918244389,
			},
		},
		runways = {
			{
				hdg = 079,
				length = 2400,
				name = '08-26',
				x =	41395.73828125,
				y = -142141.3125,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,		
		x =	41395.73828125,
		y = -142141.3125,
	},
	['Al Dhafra AFB'] = {
		ATC_frequency = {251.1, 126.5, 39.5, 4.3},
		ILS = 'RNW 128 : 111.10 || RNW 128 : 108.70 || RNW 308 : 109.10 || RNW 308 : 108.70 || ',	--- ILS : optionnel
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 251,
		LimitedSmallParkNb = '',
		VOR = "114.90",
		TACAN = "96X",							-- TACAN : optionnel
		airdromeId = 4,
		code = {
			ICAO = 'OMAM',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 16,
		parkAlertSAR = {
			{
				["y"] = -174043.65433513,
				["x"] = -210101.52359901,
			},
			{
				["y"] = -173933.40958426,
				["x"] = -210236.65310839,
			},			
			{
				["y"] = -173805.85638112,
				["x"] = -210334.93180589,
			},
			{
				["y"] = -173709.66871973,
				["x"] = -210439.48361175,
			},
			{
				["y"] = -173590.47966106,
				["x"] = -210523.12505643,
			},
			{
				["y"] = -173360.46568819,
				["x"] = -210696.68105414,
			},
			{
				["y"] = -173222.45730447,
				["x"] = -210801.23285999,
			},
			{
				["y"] = -173090.72202909,
				["x"] = -210903.69362973,
			},
		},
		runways = {
			{
				hdg = 126,
				length = 3500,
				name = '13L-31R',      ---Principale
				x =	-209935.484375,
				y = -174592.0625,
			},
			{
				hdg = 126,
				length = 3500,
				name = '13R-31L',     
				x =	-212980.48768858,
				y = -172891.236796,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 300,
		x =	-209935.484375,
		y = -174592.0625,
	},
	['Dubai Intl'] = {
		ATC_frequency = {251.15, 118.75, 39.55, 4.325},
		ILS = 'RNW 30R : 110.90 || RNW 30L : 111.30 || RNW 12L : 110.10 || RNW 12R/109.50 || ',		-- ILS : optionnel		
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 96,
		LimitedSmallParkNb = '',
		airdromeId = 5,
		code = {
			ICAO = 'OMDB',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 5,
		parkAlertSAR = {
			{
				["y"] = -89721.606493161,
				["x"] = -100187.77394424,
			},
			{
				["y"] = -89644.991813113,
				["x"] = -100233.63325016,
			},			
			{
				["y"] = -89572.286882144,
				["x"] = -100276.59525482,
			},
			{
				["y"] = -89513.351824465,
				["x"] = -100314.04931017,
			},
			{
				["y"] = -89457.170741443,
				["x"] = -100346.54621113,
			},
			{
				["y"] = -89400.989658422,
				["x"] = -100381.79708676,
			},
			{
				["y"] = -89340.95301088,
				["x"] = -100420.35273197,
			},
			{
				["y"] = -89003.442286945,
				["x"] = -100646.29923226,
			},
		},		
		runways = {
			{
				hdg = 120,
				length = 3400,
				name = '12L-30R',    ---Principale
				x =	-101509.84375,
				y = -87472.578125,
				
			},
			{
				hdg = 120,
				length = 3400,
				name = '12R-30L',
				x =	-101934.75831996,
				y = -87451.906548672,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 300,
		x =	-101509.84375,
		y = -87472.578125,
	},
	['Al Maktoum Intl'] = {
		ATC_frequency = {251.2, 118.6, 39.6, 4.35},
		ILS = 'RNW 30 : 109.75 || RNW 12 : 111.75 || ',							-- ILS : optionnel
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 58,
		LimitedSmallParkNb = '',
		airdromeId = 6,
		code = {
			ICAO = 'OMDW',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 38,
		parkAlertSAR = {
			{
				["y"] = -111057.74052738,
				["x"] = -140083.49229348,
			},
			{
				["y"] = -110941.29275896,
				["x"] = -140148.43431817,
			},			
			{
				["y"] = -110831.56313103,
				["x"] = -140220.09448335,
			},
			{
				["y"] = -110724.07288326,
				["x"] = -140280.55774772,
			},
			{
				["y"] = -110625.54015614,
				["x"] = -140343.26039225,
			},
			{
				["y"] = -110513.57114805,
				["x"] = -140410.44179711,
			},
			{
				["y"] = -109908.93850434,
				["x"] = -140786.6576643,
			},
			{
				["y"] = -109776.81507479,
				["x"] = -140867.27535013,
			},
		},				
		runways = {
			{
				hdg = 120,
				length = 4300,
				name = '12-30',
				x =	-141081.625,
				y = -108598.2421875,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 300,
		x =	-141081.625,
		y = -108598.2421875,
	},
	['Fujairah Intl'] = {
		ATC_frequency = {251.25, 124.6, 39.65, 4.375},
		ILS = 'RNW 29 : 111.50',							-- ILS : optionnel
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 4,
		LimitedSmallParkNb = '',
		VOR = "113.80",
		airdromeId = 7,
		code = {
			ICAO = 'OMFJ',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 31,
		parkAlertSAR = {
			{
				["y"] = 6869.284959169,
				["x"] = -116955.21367096,
			},
			{
				["y"] = 6997.0191026661,
				["x"] = -117001.25737385,
			},			
			{
				["y"] = 7121.7826846865,
				["x"] = -117057.69804191,
			},
			{
				["y"] = 7271.7960392587,
				["x"] = -117108.19758701,
			},
			{
				["y"] = 7482.7059041027,
				["x"] = -117175.03522024,
			},
			{
				["y"] = 7681.7335230401,
				["x"] = -117258.21094159,
			},
			{
				["y"] = 7858.4819309024,
				["x"] = -117326.53385555,
			},
			{
				["y"] = 8004.0394432595,
				["x"] = -117396.34205025,
			},
		},
		runways = {
			{
				hdg = 111,
				length = 2900,
				name = '11-29',
				x =	-118114.78125,
				y = 9254.498046875,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,
		x =	-118114.78125,
		y = 9254.498046875,
	},
	['Tunb Island AFB'] = {
		ATC_frequency = {251},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 4,
		LimitedSmallParkNb = '',
		airdromeId = 8,
		code = {
			ICAO = 'OIBX',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 13,
		parkAlertSAR = {
			{
				["y"] = -92918.305285076,
                ["x"] = 9816.8002231984,
			},
			{
				 ["y"] = -92845.434145651,
                 ["x"] = 9964.198664309,
			},			
			{
				["y"] = -92770.906843966,
				["x"] = 10096.691645083,
			},
			{
				["y"] = -92605.290617999,
				["x"] = 10404.737825381,
			},
			{
				["y"] = -92527.450991794,
				["x"] = 10593.540322984,
			},
			{
				["y"] = -92428.081256214,
				["x"] = 10774.062009288,
			},
			{
				["y"] = -92340.304656452,
				["x"] = 10976.113804967,
			},
			{
				["y"] = -92247.55956991,
				["x"] = 11135.105381896,
			},
		},		
		runways = {
			{
				hdg = 025,
				length = 1800,
				name = '03-21',
				x =	9707.2099609375,
				y = -92900.5859375,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,
		x =	9707.2099609375,
		y = -92900.5859375,
	},
	['Havadarya'] = {
		ATC_frequency = {251.3, 123.15, 39.7, 4.4},
		ILS = 'RNW 08 : 108.90 || ',							-- ILS : optionnel
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 22,
		LimitedSmallParkNb = '',		
		TACAN = "47X",							-- TACAN : optionnelelevation = 9,
		airdromeId = 9,
		code = {
			ICAO = 'OIKP',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 22,
		parkAlertSAR = {
			{
				["y"] = -7305.7706179045,
                ["x"] = 109137.71076361,
			},
			{
				["y"] = -7071.0264305583,
                ["x"] = 109184.57948361,
			},			
			{
				["y"] = -7018.5494876532,
                ["x"] = 109196.59710412,
			},
			{
				["y"] = -6855.1098486818,
                ["x"] = 109226.24056805,
			},
			{
				["y"] = -6732.1295321028,
                ["x"] = 109249.07404702,
			},
			{
				["y"] = -6666.8337939843,
                ["x"] = 109264.69695369,
			},
			{
				["y"] = -6227.3894705734,
                ["x"] = 109352.42558343,
			},
			{
				["y"] = -6178.1172264717,
                ["x"] = 109360.43733044,
			},
		},
		runways = {
			{
				hdg = 077,
				length = 2100,
				name = '08-26',
				x =	109479.28125,
				y = -5180.5727539062,
			},
		},
		side = "blue",							-- side : info obligatoire
		startup = 600,
		x =	109479.28125,
		y = -5180.5727539062,
	},
	['Khasab'] = {
		ATC_frequency = {250, 124.35, 38.4, 3.75},
		ILS = 'RNW 19 : 110.30 || ',							-- ILS : optionnel
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 12,
		LimitedSmallParkNb = '',
		airdromeId = 10,
		code = {
			ICAO = 'OOKB',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 22,
		parkAlertSAR = {
			{
				["y"] = -457.90610873692,
				["x"] = -1084.7382332268,
			},
			{
				["y"] = -442.68984447765,
				["x"] = -1017.1236721819,
			},			
			{
				["y"] = -410.45577668076,
				["x"] = -899.30259678637,
			},
			{
				["y"] = -397.11754173032,
				["x"] = -833.72294161339,
			},
			{
				["y"] = -377.66594909427,
				["x"] = -768.1432864404,
			},
			{
				["y"] = -358.21435645821,
				["x"] = -689.78115610659,
			},
			{
				["y"] = -338.76276382216,
				["x"] = -615.86510408958,
			},
			{
				["y"] = -318.1996516069,
				["x"] = -527.49929754293,
			},
		},
		runways = {
			{
				hdg = 012,
				length = 2400,
				name = '01-19',
				x =	883.880859375,
				y = 128.69967651367,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,
		x =	883.880859375,
		y = 128.69967651367,
	},	
	['Lar'] = {
		ATC_frequency = {250.05, 127.35, 38.45, 3.775},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 5,
		LimitedSmallParkNb = '',
		VOR = "117.9",
		NDB = "224",
		airdromeId = 11,
		code = {
			ICAO = 'OISL',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 803,		
		parkAlertSAR = {
			{
				["y"] = -183162.46839198,
                ["x"] = 168916.77199979,
			},
			{
				["y"] = -183056.11706249,
                ["x"] = 168915.41720579,
			},			
			{
				["y"] = -182954.50751202,
                ["x"] = 168916.09460279,
			},
			{
				["y"] = -182730.28910399,
                ["x"] = 168914.73980878,
			},
			{
				["y"] = -182623.26037749,
                ["x"] = 168914.73980878,
			},
			{
				["y"] = -182531.81178207,
                ["x"] = 168909.32063276,
			},
			{
				["y"] = -182262.88517183,
                ["x"] = 168888.99872266,
			},
			{
				["y"] = -182136.88932925,
                ["x"] = 168842.25832945,
			},
		},
		runways = {
			{
				hdg = 088,
				length = 3000,
				name = '09-27',
				x =	169016.75,
				y = -183822.578125,
			},
		},
		side = "blue",							-- side : info obligatoire
		startup = 300,
		x =	169016.75,
		y = -183822.578125,
	},
	['Al Minhad AFB'] = {
		ATC_frequency = {250.1, 118.55, 38.5, 3.8},
		ILS = 'RNW 27 : 110.75 || RNW 09 : 110.70 || ',							-- ILS : optionnel
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 61,
		LimitedSmallParkNb = '',		
		TACAN = "99X",							-- TACAN : optionnel
		airdromeId = 12,
		code = {
			ICAO = 'OMDM',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 55,		
		parkAlertSAR = {
			{
				["y"] = -90855.033318994,
				["x"] = -126100.12463871,
			},
			{
				["y"] = -90682.101863278,
				["x"] = -126097.19359709,
			},			
			{
				["y"] = -90497.446241072,
				["x"] = -126097.19359709,
			},
			{
				["y"] = -90349.917146082,
				["x"] = -126095.23956934,
			},
			{
				["y"] = -90223.882356322,
				["x"] = -126093.28554159,
			},
			{
				["y"] = -89933.709235713,
				["x"] = -126104.03269421,
			},
			{
				["y"] = -89790.088196219,
				["x"] = -126102.07866646,
			},
			{
				["y"] = -89624.972851496,
				["x"] = -126099.14762484,
			},
		},
		runways = {
			{
				hdg = 088,
				length = 3800,
				name = '09-27',
				x =	-126043.78125,
				y = -87325.1640625,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,
		x =	-126043.78125,
		y = -87325.1640625,
	},
	['Qeshm Island'] = {
		ATC_frequency = {250.15, 118.05, 38.55, 3.825},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 12,
		LimitedSmallParkNb = '',
		VOR = "117.10",
		NDB = "233",
		airdromeId = 13,
		code = {
			ICAO = 'OIKQ',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 5,
		parkAlertSAR = {
			{
				 ["y"] = -34285.426617314,
                 ["x"] = 64587.587807287,
			},
			{
				 ["y"] = -34202.876797209,
                 ["x"] = 64665.352130574,
			},			
			{
				["y"] = -34242.357145954,
                ["x"] = 64525.376348657,
			},
			{
				["y"] = -34153.825454827,
                ["x"] = 64603.140671944,
			},
			{
				["y"] = -34200.4840488,
                ["x"] = 64452.397522187,
			},
			{
				["y"] = -34111.952357673,
                ["x"] = 64533.750968088,
			},
			{
				["y"] = -34140.665338579,
                ["x"] = 64391.382437762,
			},
			{
				["y"] = -34049.740899043,
                ["x"] = 64470.343135253,
			},
		},
		runways = {
			{
				hdg = 047,
				length = 4100,
				name = '05-23',
				x =	66079.171875,
				y = -31812.6796875,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,		
		x =	66079.171875,
		y = -31812.6796875,
	},
	['Sharjah Intl'] = {
		ATC_frequency = {250.2, 118.6, 38.6, 3.85},
		ILS = 'RNW 30R : 111.95 RNW || 12L : 108.55 || ',							-- ILS : optionnel
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 47,
		LimitedSmallParkNb = '',
		airdromeId = 14,
		code = {
			ICAO = 'OMSJ',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 30,
		parkAlertSAR = {
			{
				["y"] = -74993.615972287,
				["x"] = -91914.642525066,
			},
			{
				["y"] = -74847.718436795,
				["x"] = -92014.686549404,
			},			
			{
				["y"] = -74759.137790246,
				["x"] = -92074.087688855,
			},
			{
				["y"] = -74678.894145725,
				["x"] = -92119.941200009,
			},
			{
				["y"] = -74598.129438578,
				["x"] = -92176.215963699,
			},
			{
				["y"] = -74519.448981937,
				["x"] = -92224.153725361,
			},
			{
				["y"] = -74455.879341473,
				["x"] = -92261.149171861,
			},
			{
				["y"] = -74398.56245253,
				["x"] = -92292.933992093,
			},
		},
		runways = {
			{
				hdg = 121,
				length = 3200,
				name = '12L-30R',     ---Principale
				x =	-93431.3203125,
				y = -72062,
			},
			{
				hdg = 121,
				length = 3200,
				name = '12R-30L',
				x =	-92798.728817001,
				y = -73441.694970292,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,		
		x =	-93431.3203125,
		y = -72062,
	},
	['Sirri Island'] = {
		ATC_frequency = {250.25, 135.05, 38.65, 3.875},
		VOR = "113.75",
		NDB = "300",
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 2,
		LimitedSmallParkNb = '',
		airdromeId = 15,
		code = {
			ICAO = 'OIBS',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 4,
		parkAlertSAR = {
			{
				["y"] = -171455.025738,
				["x"] = -26304.148672612,
			},
			{
				["y"] = -171378.09567975,
				["x"] = -26360.438959135,
			},			
			{
				["y"] = -171322.74356467,
				["x"] = -26407.347531237,
			},
			{
				["y"] = -171252.38070651,
				["x"] = -26458.94696055,
			},
			{
				["y"] = -171188.58504846,
				["x"] = -26513.360904189,
			},
			{
				["y"] = -171103.21144723,
				["x"] = -26565.898504943,
			},
			{
				["y"] = -171020.65236033,
				["x"] = -26626.879648677,
			},
			{
				["y"] = -170944.66047352,
				["x"] = -26687.86079241,
			},
		},
		runways = {
			{
				hdg = 125,
				length = 2400,
				name = '12-30',
				x =	-27656.474609375,
				y = -169860.078125,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,
		x =	-27656.474609375,
		y = -169860.078125,
	},
	['Tunb Kochak'] = {
		ATC_frequency = {251},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 2,
		LimitedSmallParkNb = '',
		TACAN = "89X",							-- TACAN : optionnel		
		airdromeId = 16,
		code = {
			ICAO = '',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 5,		
		parkAlertSAR = {
			{
				["y"] = -109774.59964422,
				["x"] = 8930.7052901577,
			},
			{
				["y"] = -109685.63830411,
				["x"] = 8944.3218218069,
			},			
			{
				["y"] = -109604.84688299,
				["x"] = 8955.2150471263,
			},
			{
				["y"] = -109524.96323065,
				["x"] = 8969.7393475521,
			},
			{
				["y"] = -109448.71065341,
				["x"] = 8979.7248040949,
			},
			{
				["y"] = -109249.00152256,
				["x"] = 9013.3122488296,
			},
			{
				["y"] = -109172.74894532,
				["x"] = 9026.9287804788,
			},
			{
				["y"] = -109109.20513096,
				["x"] = 9039.6375433514,
			},
		},
		runways = {
			{
				hdg = 079,
				length = 760,
				name = '08-26',
				x =	9049.3994140625,
				y = -109088.578125,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,
		x =	9049.3994140625,
		y = -109088.578125,
	},	
	['Sir Abu Nuayr'] = {
		ATC_frequency = {250.8, 118, 38.7, 3.9}, 
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 4,
		LimitedSmallParkNb = '',		
		airdromeId = 17,
		code = {
			ICAO = 'OMSN',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 8,
		parkAlertSAR = {
			{
				["y"] = -203326.04647204,
				["x"] = -102989.33091289,
			},
			{
				["y"] = -203274.21819402,
				["x"] = -103006.72592769,
			},			
			{
				["y"] = -202974.57662901,
				["x"] = -103050.43304319,
			},
			{
				["y"] = -202918.25302656,
				["x"] = -103063.95070778,
			},
			{
				["y"] = -202831.7399732,
				["x"] = -103078.36955,
			},
			{
				["y"] = -202772.26224902,
				["x"] = -103090.08485931,
			},
			{
				["y"] = -202693.40920559,
				["x"] = -103104.95429036,
			},
			{
				["y"] = -202631.67853731,
				["x"] = -103113.06488911,
			},
		},
		runways = {
			{
				hdg = 097,
				length = 700,
				name = '10-28',
				x =	-103189.046875,
				y = -202643.03125,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,
		x =	-103189.046875,
		y = -202643.03125,
	},		
	['Kerman Airbase'] = {
		ATC_frequency = {250.3, 118.25, 38.75, 3.925},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 42,
		LimitedSmallParkNb = '',
		VOR = "112.00",
		TACAN = "97X",							-- TACAN : optionnel		
		airdromeId = 18,
		code = {
			ICAO = 'OIKK',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 1751,
		parkAlertSAR = {
			{
				["y"] = 70552.036482739,
                ["x"] = 455820.69399651,
			},
			{
				["y"] = 70597.949126168,
                ["x"] = 455689.51501529,
			},			
			{
				["y"] = 70635.428835089,
                ["x"] = 455580.82385942,
			},
			{
				["y"] = 70734.75006373,
                ["x"] = 455320.33988241,
			},
			{
				["y"] = 70683.215463964,
                ["x"] = 455453.39284908,
			},
			{
				["y"] = 70792.055558408,
                ["x"] = 455181.75079667,
			},
			{
				["y"] = 70878.221371691,
                ["x"] = 454991.74413148,
			},
			{
				["y"] = 70934.311200681,
                ["x"] = 454825.49255925,
			},
		},
		runways = {
			{
				hdg = 155,
				length = 3700,
				name = '16-34',
				x =	452408.40625,
				y = 71741.5859375,
			},
		},
		side = "blue",							-- side : info obligatoire
		startup = 300,
		x =	452408.40625,
		y = 71741.5859375,
	},
	['Shiraz Intl'] = {
		ATC_frequency = {250.35, 121.9, 38.8, 3.95},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 119,
		LimitedSmallParkNb = '',
		VOR = "117.80",
		NDB = "205",
		TACAN = "94X",							-- TACAN : optionnel		
		airdromeId = 19,
		code = {
			ICAO = 'OISS',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 1487,
		parkAlertSAR = {
			{
				["y"] = -352486.55820053,
				["x"] = 381305.07916374,
			},
			{
				["y"] = -352379.14455188,
                ["x"] = 381236.81628422,
			},			
			{
				["y"] = -352186.40230384,
                ["x"] = 381139.44129433,
			},
			{
				["y"] = -352077.98478932,
				["x"] = 381090.25186644,
			},
			{
				["y"] = -351816.71897722,
                ["x"] = 380945.58721952,
			},
			{
				["y"] = -351689.5010716,
                ["x"] = 380877.03456571,
			},
			{
				["y"] = -351443.5505047,
                ["x"] = 380700.55020301,
			},
			{
				["y"] = -351290.63056793,
                ["x"] = 380625.53287553,
			},
		},
		runways = {
			{
				hdg = 113,
				length = 4200,
				name = '11L-29R',     --- Principale
				x =	380165.53125,
				y = -349843.03125,
			},
			{
				hdg = 113,
				length = 4200,
				name = '11R-29L',
				x =	380704.40241455,
				y = -351865.74052654,
			},
		},
		side = "blue",							-- side : info obligatoire
		startup = 300,
		x =	380165.53125,
		y = -349843.03125,
	},
	['Sas Al Nakheel'] = {             --be careful not fully operationnal
		ATC_frequency = {250.45, 128.9, 38.9, 4},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 87,
		LimitedSmallParkNb = '',
		VOR = "128.93",		
		airdromeId = 20,
		code = {
			ICAO = 'OMNK',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 3,
		parkAlertSAR = {
			{
				["y"] = -176286.49128134,
				["x"] = -188768.51480994,
			},
			{
				["y"] = -176272.24673994,
				["x"] = -188821.30011262,
			},			
			{
				["y"] = -176257.93938014,
				["x"] = -188866.904822,
			},
			{
				["y"] = -176192.6608863,
				["x"] = -189061.54878103,
			},
			{
				["y"] = -176135.65207569,
				["x"] = -189238.57614029,
			},
			{
				["y"] = -175898.20949046,
				["x"] = -190083.28529893,
			},
			{
				["y"] = -175871.72395456,
				["x"] = -190168.51454346,
			},
			{
				["y"] = -175843.28938507,
				["x"] = -190253.28175061,
			},
		},
		runways = {
			{
				hdg = 160,
				length = 1800,
				name = '16-34',
				x =	-188819.25,
				y = -176195.984375,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,
		x =	-188819.25,
		y = -176195.984375,
	},
	['Bandar-e-Jask'] = {             --be careful not fully operationnal
		ATC_frequency = {250.5, 118.15, 39.95, 4.025},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 2,
		LimitedSmallParkNb = '',
		VOR = "116.30",
		TACAN = "110X",							-- TACAN : optionnel
		airdromeId = 21,
		code = {
			ICAO = 'OIZJ',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 8,
		parkAlertSAR = {
			{
				["y"] = -249560.15595404,
				["x"] = -274700.04919535,
			},
			{
				["y"] = 156990.44944228,
				["x"] = -56761.285373807,
			},			
			{
				["y"] = 156873.4660487,
				["x"] = -56824.025070923,
			},
			{
				["y"] = 156758.44327065,
				["x"] = -56889.378922086,
			},
			{
				["y"] = 156642.11341558,
				["x"] = -56952.118619203,
			},
			{
				["y"] = 156510.03613841,
				["x"] = -57024.521405296,
			},
			{
				["y"] = 156365.23654907,
				["x"] = -57103.101670242,
			},
			{
				["y"] = 156231.03205163,
				["x"] = -57177.267313563,
			},
		},
		runways = {
			{
				hdg = 059,
				length = 2200,
				name = '06-24',
				x =	-57716.9375,
				y = 155264.78125,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,
		x =	-57716.9375,
		y = 155264.78125,
	},
	['Abu Dhabi Intl'] = {
		ATC_frequency = {250.55, 119.2, 39, 4.05},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 126,
		LimitedSmallParkNb = '',
		VOR = "114.25",
		airdromeId = 22,
		code = {
			ICAO = 'OMAA',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 28,
		parkAlertSAR = {
			{
				["y"] = -163880.91063972,
				["x"] = -189707.95083249,
			},
			{
				["y"] = -163802.11169556,
				["x"] = -189765.60859651,
			},			
			{
				["y"] = -163738.68815515,
				["x"] = -189819.42250959,
			},
			{
				["y"] = -163675.26461473,
				["x"] = -189877.0802736,
			},
			{
				["y"] = -163606.07529791,
				["x"] = -189940.50381402,
			},
			{
				["y"] = -163527.27635376,
				["x"] = -189992.39580163,
			},
			{
				["y"] = -163323.55225424,
				["x"] = -190148.07176447,
			},
			{
				["y"] = -163237.06560822,
				["x"] = -190217.26108129,
			},
		},
		runways = {
			{
				hdg = 127,
				length = 3900,
				name = '13L-31R',
				x =	-187211.25,
				y = -163535.515625,
			},
			{
				hdg = 127,
				length = 4000,
				name = '13R-31L',
				x =	-190741.10665265,
				y = -162381.20207133,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 300,
		x =	-187211.25,
		y = -163535.515625,
	},
	['Al-Bateen'] = {
		ATC_frequency = {250.6, 119.9, 39.05, 4.075},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 48,
		LimitedSmallParkNb = '',
		VOR = "114",
		airdromeId = 23,
		code = {
			ICAO = 'OMAD',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 4,
		parkAlertSAR = {
			{
				["y"] = -183163.52482559,
				["x"] = -190085.65221952,
			},
			{
				["y"] = -182981.84561307,
				["x"] = -190242.44462636,
			},			
			{
				["y"] = -182878.16232191,
				["x"] = -190329.63284847,
			},
			{
				["y"] = -182793.33053823,
				["x"] = -190410.53723476,
			},
			{
				["y"] = -182705.35683664,
				["x"] = -190481.23038783,
			},
			{
				["y"] = -182550.61737937,
				["x"] = -190607.69258387,
			},
			{
				["y"] = -182322.8283306,
				["x"] = -190796.99313819,
			},
			{
				["y"] = -182168.87435281,
				["x"] = -190911.67314206,
			},
		},
		runways = {
			{
				hdg = 127,
				length = 2100,
				name = '13-31',
				x =	-190269.109375,
				y = -182714.796875,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 300,
		x =	-190269.109375,
		y = -182714.796875,
	},
	['Kish Intl'] = {
		ATC_frequency = {250.65, 121.65, 39.1, 4.1},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 46,
		LimitedSmallParkNb = '',
		VOR = "117.40",
		NDB = "201",
		TACAN = "112X",							-- TACAN : optionnel
		airdromeId = 24,
		code = {
			ICAO = 'OIBK',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 35,		
		parkAlertSAR = {
			{
				["y"] = -226732.23390165,
                ["x"] = 42811.518979334,
			},
			{
				["y"] = -226506.34577421,
                ["x"] = 42794.263636266,
			},			
			{
				["y"] = -226305.55632759,
                ["x"] = 42769.164955439,
			},
			{
				["y"] = -226092.21754056,
                ["x"] = 42742.49760706,
			},
			{
				["y"] = -225786.32736799,
                ["x"] = 42769.164955439,
			},
			{
				["y"] = -225624.75461016,
                ["x"] = 42695.43758051,
			},
			{
				["y"] = -225409.84715558,
                ["x"] = 42678.182237441,
			},
			{
				["y"] = -225223.17571693,
                ["x"] = 42659.358226821,
			},
		},
		runways = {
			{
				hdg = 094,
				length = 3500,
				name = '10-28',
				x =	42988.859375,
				y = -226699.40625,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 300,
		x =	42988.859375,
		y = -226699.40625,
	},
	['Al Ain Intl'] = {
		ATC_frequency = {250.7, 119.85, 39.15, 4.125},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 74,
		LimitedSmallParkNb = '',
		VOR = "112.60",
		airdromeId = 25,
		code = {
			ICAO = 'OMAL',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 248,
		parkAlertSAR = {
			{
				["y"] = -65176.278403298,
				["x"] = -210397.22597619,
			},
			{
				["y"] = -65212.409457811,
				["x"] = -210507.57608472,
			},			
			{
				["y"] = -65241.526121315,
				["x"] = -210632.36178545,
			},
			{
				["y"] = -65259.204095585,
				["x"] = -210738.42963107,
			},
			{
				["y"] = -65272.722546498,
				["x"] = -210838.25819166,
			},
			{
				["y"] = -65287.28087825,
				["x"] = -210949.52544148,
			},
			{
				["y"] = -65312.238018396,
				["x"] = -211152.30220517,
			},
			{
				["y"] = -65318.477303433,
				["x"] = -211262.52957415,
			},
		},
		runways = {
			{
				hdg = 006,
				length = 3900,
				name = '01-19',
				x =	-209361.96875,
				y = -65151.40625,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 300,
		x =	-209361.96875,
		y = -65151.40625,
	},
	['Lavan Island'] = {
		ATC_frequency = {250.75, 128.55, 39.2, 4.15},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 3,
		LimitedSmallParkNb = '',
		VOR = "116.85",
		NDB = "310",
		airdromeId = 26,
		code = {
			ICAO = 'OIBV',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 23,
		parkAlertSAR = {
			{
				["y"] = -287337.44396056,
                ["x"] = 75907.055437118,
			},
			{
				["y"] = -287256.70557212,
                ["x"] = 75878.725044075,
			},			
			{
				["y"] = -287183.78765334,
                ["x"] = 75841.560427405,
			},
			{
				["y"] = -287116.51499279,
                ["x"] = 75811.452383521,
			},
			{
				["y"] = -287043.12663582,
                ["x"] = 75782.755654194,
			},
			{
				["y"] = -286843.04396725,
                ["x"] = 75713.92735655,
			},
			{
				["y"] = -286760.53638293,
                ["x"] = 75673.590315324,
			},
			{
				["y"] = -286663.36078361,
                ["x"] = 75636.920277846,
			},
		},   
		runways = {
			{
				hdg = 110,
				length = 2600,
				name = '11-29',
				x =	76294.1171875,
				y = -287950.9375,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 300,
		x =	76294.1171875,
		y = -287950.9375,
	},
	['Jiroft'] = {
		ATC_frequency = {250.85, 136, 39.25, 4.175},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 3,
		LimitedSmallParkNb = '',
		NDB = "276",
		airdromeId = 27,
		code = {
			ICAO = 'OIKJ',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 812,
		parkAlertSAR = {
			{
				["y"] = 141693.23987083,
                ["x"] = 282806.49192959,
			},
			{
				["y"] = 142033.50399607,
                ["x"] = 282545.3483766,
			},			
			{
				["y"] = 142296.45748916,
                ["x"] = 282337.53029335,
			},
			{
				["y"] = 142567.89335301,
                ["x"] = 282095.78272711,
			},
			{
				["y"] = 141799.82156822,
                ["x"] = 282725.48983957,
			},
			{
				["y"] = 141918.99199101,
                ["x"] = 282638.6544548,
			},
			{
				["y"] = 142160.73955724,
                ["x"] = 282439.31874229,
			},
			{
				["y"] = 142440.65779183,
                ["x"] = 282218.77710292,
			},
		},   
		runways = {
			{
				hdg = 125,
				length = 2900,
				name = '13-31',
				x =	283496.71875,
				y = 140608.3125,
			},
		},
		side = "blue",							-- side : info obligatoire
		startup = 600,
		x =	283496.71875,
		y = 140608.3125,
	},
	['Ras Al Khaimah Intl'] = {
		ATC_frequency = {250.9, 121.6, 39.3, 4.2},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 18,
		LimitedSmallParkNb = '',
		VOR = "113.60",
		airdromeId = 28,
		code = {
			ICAO = 'OMRK',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 22,
		parkAlertSAR = {
			{
				["y"] = -30993.435667731,
				["x"] = -60423.582467215,
			},
			{
				["y"] = -30971.172967765,
				["x"] = -60532.276825875,
			},			
			{
				["y"] = -30935.814561936,
				["x"] = -60696.62793445,
			},
			{
				["y"] = -30908.968364917,
				["x"] = -60794.84572842,
			},
			{
				["y"] = -30883.186448344,
				["x"] = -60866.649097204,
			},
			{
				["y"] = -30854.006161455,
				["x"] = -60960.887072894,
			},
			{
				["y"] = -30834.393181743,
				["x"] = -61107.266872697,
			},
			{
				["y"] = -30805.212894854,
				["x"] = -61192.894271928,
			},
		},  
		runways = {
			{
				hdg = 163,
				length = 3600,
				name = '17-35',
				x =	-62870.8828125,
				y = -30497.56640625,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 600,
		x =	-62870.8828125,
		y = -30497.56640625,
	},
	['Liwa AFB'] = {             --be careful not fully operationnal
		ATC_frequency = {250.95, 119.3, 39.35, 4.225},
		LimitedLargeParkNb = '',
		LimitedMediumParkNb = '',
		LimitedParkNb = 65,
		LimitedSmallParkNb = '',
		VOR = "117.40",
		TACAN = "121X",							-- TACAN : optionnel
		airdromeId = 29,
		code = {
			ICAO = 'OMLW',
		},
		divert = true,							-- divert : info obligatoire (pour l instant)
		elevation = 122,
		parkAlertSAR = {
			{
				["y"] = -249560.15595404,
				["x"] = -274700.04919535,
			},
			{
				["y"] = -249381.86336287,
				["x"] = -274968.58865366,
			},			
			{
				["y"] = -249174.95591138,
				["x"] = -275105.05952592,
			},
			{
				["y"] = -249031.88160982,
				["x"] = -275217.31782407,
			},
			{
				["y"] = -248846.98558934,
				["x"] = -275322.97269291,
			},
			{
				["y"] = -248681.89985678,
				["x"] = -275604.71900983,
			},
			{
				["y"] = -248525.61869661,
				["x"] = -275738.98873898,
			},
			{
				["y"] = -248338.52153303,
				["x"] = -275893.06875605,
			},
		},
		runways = {
			{
				hdg = 130,
				length = 3500,
				name = '13-31',
				x =	-274638.75,
				y = -249407.125,
			},
		},
		side = "red",							-- side : info obligatoire
		startup = 300,
		x =	-274638.75,
		y = -249407.125,
	},
	['FARP Moscow'] = {                              ----- DCE campaigns only
		ATC_frequency = {243},		
		LimitedParkNb = 4,
		airdromeId = 1645,
		code = {
			ICAO = 'MOSC',
		},
		divert = false,							-- divert : info obligatoire (pour l instant)
		elevation = 9,
		parkAlertSAR = {
			{
				["y"] = -249560.15595404,
				["x"] = -274700.04919535,
			},
			{
				["y"] = -43388.362616409,
				["x"] = 66939.954667024,
			},			
			{
				["y"] = -43290.473024599,
				["x"] = 66990.54928751,
			},
			{
				["y"] = -43524.74811511,
				["x"] = 66862.962853241,
			},
			{
				["y"] = -43138.689163142,
				["x"] = 67032.344843563,
			},
			{
				["y"] = -43419.159341922,
				["x"] = 66802.469285269,
			},
			{
				["y"] = -43309.171036518,
				["x"] = 66875.061566836,
			},
			{
				["y"] = -43182.684485303,
				["x"] = 66913.557473727,
			},
		},
		side = "red",							-- side : info obligatoire
		x =	67050.376929269,
		y = -42926.343389078,
	},
	['FARP Warsaw'] = {                                   ----- DCE campaigns only
		ATC_frequency = {244},
		LimitedParkNb = 4,
		elevation = 9,
		airdromeId = 1665,
		code = {
			ICAO = 'WARS',
		},
		divert = false,							-- divert : info obligatoire (pour l instant)
		parkAlertSAR = {
			{
				["y"] = -249560.15595404,
				["x"] = -274700.04919535,
			},
			{
				["y"] = -42459.828537771,
				["x"] = 66784.390449712,
			},			
			{
				["y"] = -42342.118604964,
				["x"] = 66905.897477125,
			},
			{
				["y"] = -42156.060969237,
				["x"] = 66495.811259605,
			},
			{
				["y"] = -42079.44569118,
				["x"] = 66719.88518679,
			},
			{
				["y"] = -42387.683740244,
				["x"] = 66571.753151738,
			},
			{
				["y"] = -42215.284502679,
				["x"] = 66641.241664343,
			},
			{
				["y"] = -42015.568468791,
				["x"] = 66640.100854658,
			},
		},
		side = "red",							-- side : info obligatoire
		x =	66985.049635529,
		y = -42106.871222399,
	},
	['FARP London'] = {
		ATC_frequency = {260},
		LimitedParkNb = 4,
		elevation = 132,
		airdromeId = 1690,
		code = {
			ICAO = 'LOND',
		},
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		parkAlertSAR = {
			{
				["y"] = -20054.041884551,
				["x"] = 79306.520302262,
			},
			{
				["y"] = -19944.107410934,
				["x"] = 79375.952601389,
			},			
			{
				["y"] = -19828.386912391,
				["x"] = 79452.617431674,
			},
			{
				["y"] = -20136.492739763,
				["x"] = 79403.436219793,
			},
			{
				["y"] = -20000.521153974,
				["x"] = 79477.208037614,
			},
			{
				["y"] = -19897.819211517,
				["x"] = 79536.514793118,
			},
			{
				["y"] = -20230.515644829,
				["x"] = 79208.157878501,
			},
			{
				["y"] = -20289.822400333,
				["x"] = 79318.092352117,
			},
		},
		side = "blue",							-- side : info obligatoire		
		x =	79012.737948179,
		y = -20000.997994109,
	},
	['Reserves'] = {						--dummy airbase to place virtual reserves
		inactive = true,
		x =	9999999999,						--position far away will make all range checks negative
		y = 9999999999,
		elevation = 0,
		airdromeId = nil,					--no id makes sure that no static aircraft are to be placed at this air base
		ATC_frequency = "0",
	},
}
	